clear all;
close all;

cm = [1,2]; %Cloning Methods
Lvalues = [20,50,80];
logncvalues = [5,5,6];
colours = {'ko','kx';'ro','rx';'bo','bx'};
fitcol = {'y-','k-';'r-','c-';'b-','g-'};
ntvals = 5; %Number of time values

load('K.mat');
[M,X] = min(abs(K(:,2)-28));
analytical=K(X,1); %K at sL2=28
figure(2), hold on, plot([1,10^6],[analytical,analytical],'--','Color',[0 0.5 0],'LineWidth',3.2);
figure(3), hold on, plot([1,10^6],[analytical,analytical],'--','Color',[0 0.5 0],'LineWidth',3.2);

x=zeros(2,size(Lvalues,2),size(cm,2)); %%Variables, system sizes, cloning methods
x3=zeros(2,size(Lvalues,2),size(cm,2)); %%Variables, system sizes, cloning methods
relerr=zeros(5,size(Lvalues,2),size(cm,2)); %%Relative error of each data point
t5err=zeros(size(Lvalues,2),size(cm,2)); %%Error in 10^4 - 10^5 fit at 10^6

for j = 1:size(Lvalues,2)
for n = 1:size(cm,2)
for m = 1:ntvals
seed = 0;

logt = m;
L = Lvalues(j);
lognc = logncvalues(j);
dt = 10;

FILENAME = sprintf('%dKTrack%d,%d,%d,%d,28,%d.txt',0,cm(n),logt,L,lognc,dt);
fileID = fopen(FILENAME,'r');
formatSpec = '%f';

A = fscanf(fileID,formatSpec);

repspf=size(A,1)/5; %Repeats per file

for i=1:repspf
    k(i) = A(i*5 - 4);
end

kave(m) = mean(k)/L;
ksterr(n,m) = std(k/L)/sqrt(repspf);
diff(m) = kave(m)-analytical;
end

y = [10^(-3),1;10^(-4),1];
b = [kave(3);kave(4)];
x(:,j,n) = inv(y'*y)*(y'*b);

t=10.^linspace(1,ntvals,ntvals);
figure(1), hold on, plot(t,kave,colours{j,n},'MarkerSize',10,'LineWidth',2);
set(gca,'xscale','log')
xlim([min(t),max(t)]);
ylim([0,0.6]);
xlabel('$t_{obs}$','interpreter','latex');
yname = '$\hat{k}(\lambda)_{n_c,t_{obs}}$';
ylabel(yname,'interpreter','latex');
set(gca, 'FontSize', 24);
set(gca,'linewidth',2);
set(gca,'XTick', [1,100,10000,1000000]);
set(gca,'YTick', 0:0.2:0.4);
set(gcf,'units','points','position',[10,10,400,300]);

tfit=10.^linspace(2,5,100);
figure(2), hold on, plot(t,kave,colours{j,n},'MarkerSize',10,'LineWidth',2);
figure(2), hold on, plot(tfit,x(1,j,n)./tfit+x(2,j,n),fitcol{j,n});
set(gca,'xscale','log');
xlim([min(t),max(t)]);
ylim([0,1.2*max(max(kave))]);
xlabel('$t_{obs}$','interpreter','latex');
yname = '$\hat{k}(\lambda)_{n_c,t_{obs}}$';
ylabel(yname,'interpreter','latex');
set(gca,'XTick', [10,1000,100000]);
set(gca,'YTick', 0:0.2:0.4);

set(gcf,'units','points','position',[10,10,400,300]);
set(gca, 'FontSize',24);
set(gca,'linewidth',2);

t5err(j,n)=abs(x(1,j,n)/(10^5)+x(2,j,n)-kave(5));

y3 = [10^(-3),1;10^(-4),1;10^(-5),1];
b3 = [kave(3);kave(4);kave(5)];
x3(:,j,n) = inv(y3'*y3)*(y3'*b3);
relerr(:,j,n) = abs(x3(2,j,n)-kave(:))./kave(:);

t3=10.^linspace(1,ntvals,ntvals);
tfit3=10.^linspace(2,5,100);
figure(3), hold on, plot(t3,kave,colours{j,n},'MarkerSize',10,'LineWidth',2);
figure(3), hold on, plot(tfit3,x3(1,j,n)./tfit3+x3(2,j,n),fitcol{j,n});
set(gca,'xscale','log');
xlim([min(t3),max(t3)]);
ylim([0,1.2*max(max(kave))]);
xlabel('$t_{obs}$','interpreter','latex');
yname = '$\hat{k}(\lambda)_{n_c,t_{obs}}$';
ylabel(yname,'interpreter','latex');
set(gca,'XTick', [10,1000,100000]);
set(gca,'YTick', 0:0.2:0.4);

set(gcf,'units','points','position',[10,10,400,300]);
set(gca, 'FontSize',24);
set(gca,'linewidth',2);

end
end

figure(1), hold on, plot([1,10^6],[analytical,analytical],'--','Color',[0 0.5 0],'LineWidth',3.2);
figure(1), hold on, hold on, plot(tfit,x(1,3,2)./tfit+x(2,3,2),'-','Color',[0 0 0],'LineWidth',1.5);

figure(1), hold on, plot(20,0.25,colours{1,1},'MarkerSize',10,'LineWidth',2);
figure(1), text(32,0.25,'L=20 [iid]','FontSize',15,'interpreter','latex');
figure(1), hold on, plot(20,0.20,colours{1,2},'MarkerSize',10,'LineWidth',2);
figure(1), text(32,0.20,'L=20 [eq]','FontSize',15,'interpreter','latex');
figure(1), hold on, plot(20,0.15,colours{2,1},'MarkerSize',10,'LineWidth',2);
figure(1), text(32,0.15,'L=50 [iid]','FontSize',15,'interpreter','latex');
figure(1), hold on, plot(20,0.10,colours{2,2},'MarkerSize',10,'LineWidth',2);
figure(1), text(32,0.10,'L=50 [eq]','FontSize',15,'interpreter','latex');
figure(1), hold on, plot(2000,0.25,colours{3,1},'MarkerSize',10,'LineWidth',2);
figure(1), text(3200,0.25,'L=80 [iid]','FontSize',15,'interpreter','latex');
figure(1), hold on, plot(2000,0.20,colours{3,2},'MarkerSize',10,'LineWidth',2);
figure(1), text(3200,0.20,'L=80 [eq]','FontSize',15,'interpreter','latex');
figure(1), hold on, plot([1200,3000],[0.15,0.15],'--','Color',[0 0.5 0],'LineWidth',3.2);
figure(1), text(3800,0.15,'Theory','FontSize',15,'interpreter','latex');
figure(1), hold on, plot([1200,3000],[0.10,0.10],'-','Color',[0 0 0],'LineWidth',1.5);
figure(1), text(3800,0.10,'Fit to (26)','FontSize',15,'interpreter','latex');


pl2name = sprintf('T34fit.png');
figure(2),saveas(gcf,pl2name);
pl3name = sprintf('T345fit.png');
figure(3),saveas(gcf,pl3name);

plotname = sprintf('TConvsLL28.png');
figure(1),saveas(gcf,plotname);
